#pragma once

#include "Config.h"
#include "cstringt.h"

//#define GPRS_MAX_CTXT_NB					5
#define	GPRS_MAX_STRING						32
#define	GPRS_MAX_PDP						5
#define	GPRS_MAX_PD							3

#define	kGPRSCellIdStrLength				4
#define	kGPRSAreaCdStrLength				4

#define	kCfgEventGRegStateChange				3000

//Key
#define kGPRSSection				"GPRS"
#define	kGPRSKeyAvailable			"GPRSAvailable"
#define kGPRSKeyNotifEnable			"EnableNotif"
#define kGPRSKeyEvtMode				"EvtMode"
#define kGPRSKeyEvtBfr				"EvtBfr"
#define kGPRSKeyAttState			"AttState"
#define kGPRSKeyNbCtxt				"NbCtxt"
#define kGPRSKeyMaxNbCtxt			"MaxNbCtxt"
#define	kGPRSKeyCellId				"CellId"
#define	kGPRSKeyAreaCode			"AreaCd"
#define	kGPRSKeyRegState			"RegStat"
#define	kGPRSKeySMSServiceState		"SMSServiceStat"
#define kGPRSKeyEvtBufSize			"BfrSize"

#define	kGPRSKeyCid					"Cid"
#define	kGPRSKeyPDP					"PDP"
#define kGPRSKeyAPN					"APN"
#define kGPRSKeyPDPAddr				"PDPAddress"
#define kGPRSKeyDataComp			"DataCompression"
#define kGPRSKeyHeaderComp			"HeaderCompression"
#define	kGPRSKeyState				"State"
#define	kGPRSKeyPd1					"pd1"
#define	kGPRSKeyPd2					"pd2"
#define	kGPRSKeyPd3					"pd3"
#define	kGPRSKeyReqPrecedence		"reqPrecedence"
#define	kGPRSKeyReqDelay			"reqDelay"
#define	kGPRSKeyReqReliability		"reqReliability"
#define	kGPRSKeyReqPeak				"reqPeak"
#define	kGPRSKeyReqMean				"reqMean"
#define	kGPRSKeyMinPrecedence		"minPrecedence"
#define	kGPRSKeyMinDelay			"minDelay"
#define	kGPRSKeyMinReliability		"minReliability"
#define	kGPRSKeyMinPeak				"minPeak"
#define	kGPRSKeyMinMean				"minMean"
#define kGPRSClassKey				"class"

//default value
#define kGPRSDefNotifEnable			kGPRSRegLocationNotif
#define kGPRSDefEvtMode				kEvtModeLoopStorage
#define kGPRSDefEvtBfr				kEvtBfrCleared
#define kGPRSDefAttState			kGPRSDetached
#define kGPRSDefNbCtxt				kGPRSDefMaxNbCtxt
#define kGPRSDefMaxNbCtxt			5
#define	kGPRSDefRegState			kGPRSNwkRegistered
#define	kGPRSDefCellId				"00AD"
#define	kGPRSDefAreaCode			"00C3"
#define	kGPRSDefSMSServiceState		1
#define kGPRSDefEvtBufSize			5

#define	kGPRSDefCid					1
#define	kGPRSDefPDP					"IP"
#define kGPRSDefAPN					"MyAPN"
#define kGPRSDefPDPAddr				"0.0.0.0"
#define kGPRSDefDataComp			0
#define kGPRSDefHeaderComp			0
#define	kGPRSDefState				kGPRSCtxtDeactivated
#define	kGPRSDefPd1					""
#define	kGPRSDefPd2					""
#define	kGPRSDefPd3					""
#define kGPRSDefClass				"A"

//Possible vlaues
//CGREG
#define kGPRSNwkNotRegisteredMENotsearching	0
#define kGPRSNwkRegistered					1
#define kGPRSNwkNotRegisteredMEsearching	2
#define kGPRSNwkRegistrationDenied			3
#define kGPRSNwkUnknown						4
#define kGPRSNwkRegisteredRoaming			5

//NotifEnable
#define kGPRSNoNotif						0
#define kGPRSRegNotif						1
#define kGPRSRegLocationNotif				2

//Attachment
#define kGPRSAttached						1
#define kGPRSDetached						0

//Context activation
#define kGPRSCtxtDeactivated				0
#define kGPRSCtxtActivated					1

//Event Managment
//Mode
#define kEvtModeLoopStorage					0
#define kEvtModeDiscardWhenOnLine			1
#define kEvtModeBufferWhenOnLine			2
//buffer
#define kEvtBfrCleared						0
#define kEvtBfrFlushToTE					1

//Event Notification values
#define kGPRSEvtReject						"REJECT"
#define kGPRSEvtNwReact						"NW REACT"
#define kGPRSEvtNwDeact						"NW DEACT"
#define kGPRSEvtMeDeact						"ME DEACT"
#define kGPRSEvtNwDetach					"NW DETACH"
#define kGPRSEvtMeDetach					"ME DETACH"
#define kGPRSEvtNwClass						"NW CLASS"
#define kGPRSEvtMeClass						"ME_CLASS"
//////////////////////////////////////////////////////////////////////////

#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif
//////////////////////////////////////////////////////////////////////////

class CGPRSContext
{
public:
	CGPRSContext()
{
	mGPRSState=kGPRSDefState;	mGPRSCID=kGPRSDefCid;	mGPRSPDP=kGPRSDefPDP;				
	mGPRSAPN=kGPRSDefAPN;	mGPRSPDPAddr=kGPRSDefPDPAddr;	mGPRSDataComp=kGPRSDefDataComp;	
	mGPRSHeaderComp	=kGPRSDefHeaderComp;	mGPRSPd1=kGPRSDefPd1;	mGPRSPd2=kGPRSDefPd2;				
	mGPRSPd3=kGPRSDefPd3;
	mGPRSReqPrecedence = mGPRSReqDelay = mGPRSReqReliability = mGPRSReqPeak = mGPRSReqMean = 0;
	mGPRSMinPrecedence = mGPRSMinDelay = mGPRSMinReliability = mGPRSMinPeak = mGPRSMinMean =0;
}

	UInt8 mGPRSState; int mGPRSCID; CString mGPRSPDP;CString mGPRSAPN;	CString	mGPRSPDPAddr;		
	Bool mGPRSDataComp; Bool mGPRSHeaderComp;CString	mGPRSPd1;CString mGPRSPd2;			
	CString	mGPRSPd3;
	UInt8 mGPRSReqPrecedence; UInt8 mGPRSReqDelay; UInt8 mGPRSReqReliability; UInt8 mGPRSReqPeak;
	UInt8 mGPRSReqMean;
	UInt8 mGPRSMinPrecedence; UInt8 mGPRSMinDelay; UInt8 mGPRSMinReliability; UInt8 mGPRSMinPeak;
	UInt8 mGPRSMinMean;

};
//////////////////////////////////////////////////////////////////////////

class CGPRSEvtNotif
{
public:
	UInt8 cid;
	CString type;
	CString MSclass;
	CString PDPtype; 
	CString PDPaddr; 
};
//////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CConfigGPRS : public CConfig
{
public:
	CConfigGPRS() {};
	CConfigGPRS(CDllManager* iDllManager);
	~CConfigGPRS();

	// Common Config interface
	virtual			Bool Save();
	virtual			Bool Load();
	// NotifCrt accessors
	UInt8			GetNotifCrt();
	void			SetNotifCrt(UInt8 iNotifCrt);
	// Registration State accessors
	UInt8			GetRegState();
	void			SetRegState(UInt8 iRegState);
	// Localisation accessors
	CString 		GetAreaCode();
	CString 		GetCellID();
	void 			SetAreaCode(CString iAreaCode);
	void 			SetCellID(CString iCellID);
	// Context list accessors
	void			GetCtxtList(CList<CGPRSContext,CGPRSContext&> *ioContextList);
	void			SetCtxtList(CList<CGPRSContext,CGPRSContext&> *iContextList);
	CGPRSContext	GetCtxt(int iId);
	// Return CGPRSContext with cid=-1 if doesn't exist
	CGPRSContext	GetPDP(int iCid);
	Bool			RemoveContext(CGPRSContext* iCtxt);
	int				AddOrReplaceContext(CGPRSContext* iNewCtxt);
	UInt8			GetMaxNbCtxt();
	UInt8			GetNbCid();
	int				SetCtxtState(int iCid, int iState);
	// Attach accessors
	Bool 			AttachGPRSNet();
	Bool 			DetachGPRSNet();
	Bool 			IsAttached();
	// Event managment accessors
	void 			SetEvtMode(UInt8 iEvtMode);
	void 			SetEvtBfr(UInt8 iEvtBfr);
	UInt8 			GetEvtMode();
	UInt8 			GetEvtBfrState();
	UInt8 			GetEvtBfrSize();
	void 			SetEvtBfrSize(UInt8 iEvtBfrSize);
	void 			ClearEvtBfr();
	void 			GetAndClearEvtBfr(CList<CGPRSEvtNotif,CGPRSEvtNotif&>* ioEvtBfr);
	void 			AddEvtEntry(CGPRSEvtNotif* iEvt);
	int				FlushBfr(Bool iSilentMode=FALSE);
	// class accessors
	void			SetClass(CString iClass);
	CString			GetClass();
	CString			GetClassRange();
	// Sms service accessors
	void			SetSmsService(UInt8 iService);
	UInt8			GetSmsService();
	// Notif
	virtual	void	SendCGREGNotif();
	// Supported PDP types
	// return one string, values are delimited with #
	virtual CString GetPDPType();

private:
	
	void			PrvSendResult(CGPRSEvtNotif* iEvt);

	UInt8			mGPRSMaxNbCtxt;
	UInt8			mGPRSNbCtxt;
	UInt8			mGPRSNotifEnable;
	UInt8			mGPRSEvtMode;
	UInt8			mGPRSEvtBfr;
	UInt8			mGPRSAttState;
	UInt8			mGPRSRegState;
	UInt8			mSmsServiceStatus;
	CString			mGPRSCellId;//[kGPRSCellIdStrLength + 1];
	CString			mGPRSAreaCode;//[kGPRSAreaCdStrLength + 1];
	CList<CGPRSContext,CGPRSContext&> mCtxtList;
	CList<CGPRSEvtNotif,CGPRSEvtNotif&> mEvtBfr;
	UInt8			mGPRSEvtBufSize;
	CString			mClass;
};
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////